<?php
/*
	Stempora web framework
	copyright (c) 2002-2018 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/

global $site;

class CFormsTabs extends CLibrary{
	
	var $template; 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	public function __construct($tabs = array()) {
		$this->tabs = $tabs;


		$this->template = new CTemplateDynamic("templates/form.tabs.htm");
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	public static function NewInstance($tabs) {
		return new self($tabs);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render() {
		global $base;
		global $_IS_POPUP;

		if ($_IS_POPUP) {
			return "";
		}
		

		if (is_array($this->tabs)) {


			foreach ($this->tabs as $key => $tab) {

				if (CForm::__isRestricted($tab["restricted"])) {				
					unset($this->tabs[$key]);
				} else {

					$tab["icon"] = CXMLSimpleList::TranslateIcon($tab["icon"]);

					if ($tab["icon"]) {
						$tab["icon"] = $this->template->blockReplace("IconBig" , $tab);
					}					

					$tab["subtitle"] = $tab["subtitle"];
					$tab["target"] = $tab["target"] ? "target=\"{$tab[target]}\"" : "";

					$this->tabs[$key]["submenu"] = $tab["submenu"] = "";

					if ($tab["subtitle"]) {
						$tab["subtitle"] = $this->template->blockReplace("Subtitle" , $tab);
						$tab["no-subtitle"] = "";
					} else {
						$tab["subtitle"] = "";
						$tab["no-subtitle"] = "no-subtitle";

					}


					if (is_Array($tab["link"])) {

						if (!is_Array($tab["link"][key($tab["link"])])) {
							$tab["link"] = array(
								$tab["link"]
							);
						}
						

						foreach ($tab["link"] as $k => $v) {

							if (CForm::__isRestricted($v["restricted"])) {				
								unset($tab["link"][$k]);
							} else {

								$active = "";

								if ($v["active"]) {
									eval("\$active = {$v[active]}");
									
									if ($active) {
										$active = $this->template->blockReplace("MenuActive");
									}									
								} 

								$tab["link"][$k]["active"] = $active;


								$v["icon"] = CXMLSimpleList::TranslateIcon($v["icon"]);

								if ($v["icon"]) {
									$tab["link"][$k]["icon"] = $this->template->blockReplace("Icon" , $v);
								}					

								$v["has_icon"] = $v["icon"] ? "has-icon" : "";

								if ($v["subtitle"]) {
									$tab["link"][$k]["subtitle"] = $this->template->blockReplace("MenuSubtitle" , $v);
								} else {
									$tab["link"][$k]["subtitle"] = "";
								}

							}
						}


						if (count($tab["link"])) {
							$this->tabs[$key]["submenu"] = $tab["submenu"] = CTemplateStatic::Replace(
								$base->html->Table(
									$this->template , 
									"Menu",
									$tab["link"]
								),
								array(
									"color" => $tab["color"]
								)

							);
						}
					
						$this->tabs[$key]["content"] = $this->template->blockReplace("Menu" , $tab);
					} else {
						$this->tabs[$key]["content"] = $this->template->blockReplace("Link" , $tab);
					}



				}

				
			}
			
			if (count($this->tabs)) {

				return $base->html->table(
					$this->template , 
					"Tabs" , 
					$this->tabs
				);
			}
			
		}

	}
	
	

/*	
*/	
}


?>